<?php // -*-mode: PHP; coding:utf-8;-*-
namespace MRBS;

use IntlDateFormatter;

require_once 'lib/autoload.inc';

/**************************************************************************
 *   MRBS Configuration File
 *   Configure this file for your site.
 *   You shouldn't have to modify anything outside this file.
 *
 *   This file has already been populated with the minimum set of configuration
 *   variables that you will need to change to get your system up and running.
 *   If you want to change any of the other settings in systemdefaults.inc.php
 *   or areadefaults.inc.php, then copy the relevant lines into this file
 *   and edit them here.   This file will override the default settings and
 *   when you upgrade to a new version of MRBS the config file is preserved.
 *
 *   NOTE: if you include or require other files from this file, for example
 *   to store your database details in a separate location, then you should
 *   use an absolute and not a relative pathname.
 **************************************************************************/

/**********
 * Timezone
 **********/

// The timezone your meeting rooms run in. It is especially important
// to set this if you're using PHP 5 on Linux. In this configuration
// if you don't, meetings in a different DST than you are currently
// in are offset by the DST offset incorrectly.
//
// Note that timezones can be set on a per-area basis, so strictly speaking this
// setting should be in areadefaults.inc.php, but as it is so important to set
// the right timezone it is included here.
//
// When upgrading an existing installation, this should be set to the
// timezone the web server runs in.  See the INSTALL document for more information.
//
// A list of valid timezones can be found at http://php.net/manual/timezones.php
// The following line must be uncommented by removing the '//' at the beginning
//$timezone = "Europe/London";

$timezone = "America/Argentina/Buenos_Aires";


/*******************
 * Database settings
 ******************/
// Which database system: "pgsql"=PostgreSQL, "mysql"=MySQL
$dbsys = "mysql";
// Hostname of database server. For pgsql, can use "" instead of localhost
// to use Unix Domain Sockets instead of TCP/IP. For mysql "localhost"
// tells the system to use Unix Domain Sockets, and $db_port will be ignored;
// if you want to force TCP connection you can use "127.0.0.1".
//$db_host = "localhost";
$db_host = "127.0.0.1";
// If you need to use a non standard port for the database connection you
// can uncomment the following line and specify the port number
// $db_port = 1234;
// Database name:
$db_database = "sjbunivers_aulas";
// Schema name.  This only applies to PostgreSQL and is only necessary if you have more
// than one schema in your database and also you are using the same MRBS table names in
// multiple schemas.
//$db_schema = "public";
// Database login user name:
$db_login = "sjbunivers_bedel";
// Database login password:
$db_password = 'cuero tomate paz';
// Prefix for table names.  This will allow multiple installations where only
// one database is available
$db_tbl_prefix = "mrbs_";
// Set $db_persist to TRUE to use PHP persistent (pooled) database connections.  Note
// that persistent connections are not recommended unless your system suffers significant
// performance problems without them.   They can cause problems with transactions and
// locks (see http://php.net/manual/en/features.persistent-connections.php) and although
// MRBS tries to avoid those problems, it is generally better not to use persistent
// connections if you can.
$db_persist = false;

$override_locale = "es-AR";
$language_debug = false;



/* Add lines from systemdefaults.inc.php and areadefaults.inc.php below here
   to change the default configuration. Do _NOT_ modify systemdefaults.inc.php
   or areadefaults.inc.php.  */

$mrbs_company = "UNPSJB sede Trelew";   // This line must always be uncommented ($mrbs_company is used in various places)

// Set the earliest date for which you can make a booking.    This can be useful if you
// want to set an absolute date, eg the beginning of term, before which bookings cannot be made.
// If you want to set a relative date, eg no more than a week away, then this can be done
// using the area settings.   Note that it is possible to have both a relative and absolute
// date, eg "no earlier than a week away and in any case not before the beginning of term".
// Note that bookings are allowed on the $min_booking_date, but not before it.
$min_booking_date_enabled = true;
$min_booking_date = "2024-01-01";  // Must be a string in the format "yyyy-mm-dd"

// Start of week: 0 for Sunday, 1 for Monday, etc.
$weekstarts = 1;

// Cuándo termina el día. Sobreescribe las variables declaradas en areadefaults.inc.php
$eveningends           = 23;  // must be integer in range 0-23
$eveningends_minutes   = 00;   // must be integer in range 0-59


unset($booking_types);    // Include this line when copying to config.inc.php
$booking_types[] = "A";
$booking_types[] = "B";
$booking_types[] = "C";
$booking_types[] = "D";
$booking_types[] = "E";
$booking_types[] = "F";
$booking_types[] = "G";
$booking_types[] = "H";
$booking_types[] = "I";
$booking_types[] = "J";
$booking_types[] = "K";

$vocab_override["es"]["type.A"] =   "FHYCS";
$vocab_override["es"]["type.B"] =   "FCN";
$vocab_override["es"]["type.C"] =   "FCJ";
$vocab_override["es"]["type.D"] =   "FI";
$vocab_override["es"]["type.E"] =   "FCE";
$vocab_override["es"]["type.F"] =   "DZ";
$vocab_override["es"]["type.G"] =   "Otros";
$vocab_override["es"]["type.H"] =   "BGP";
$vocab_override["es"]["type.I"] =   "C. Idiomas";
$vocab_override["es"]["type.J"] =   "Extensión";
$vocab_override["es"]["type.K"] =   "S. Académica";
/*
$color_types = array(
        'FHYCS' => "#434C5E",
        'FCN' => "#81A1C1",
        'FCJ' => "#BF616A",
        'FI' => "#D08770",
        'FCE' => "#EBCB8B",
        'DZ' => "#A3BE8C",
        'Otros' => "#D8DEE9",
        'BGP' => "#B88EAD"
        );
*/
        
